-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.victory = false
    self.defeat = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.timer = 4
      MarkMainGoal(self)
    end
  end
  
  if self.victory then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td

  	if self.timer <= 0 then
      Citadels.SetAchievementDone(12)
      Citadels.ForceVictory()
    end
  end
  
  if self.defeat then
    
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      Citadels.ForceDefeat()
    end
  end
end

function MarkMainGoal(self)
  g1PosX = Game:GetEntity("grail"):GetPosition().x
  g1PosY = Game:GetEntity("grail"):GetPosition().y
  g2PosX = Game:GetEntity("thallP0-position"):GetPosition().x
  g2PosY = Game:GetEntity("thallP0-position"):GetPosition().y

  self.p0:AddQuest('D7G_GOAL_1', 'main')
  self.p0:SetQuestPosition('D7G_GOAL_1', g1PosX, g1PosY)
  
  self.p0:AddQuest('D07G_DEFEND', 'main')
  self.p0:SetQuestPosition('D07G_DEFEND', g2PosX, g2PosY)
end

function AddNewMarks(self)
  q1PosX = Game:GetEntity("fort"):GetPosition().x
  q1PosY = Game:GetEntity("fort"):GetPosition().y
  q2PosX = Game:GetEntity("hilltopBase-position"):GetPosition().x
  q2PosX = Game:GetEntity("hilltopBase-position"):GetPosition().y
  g3PosX = Game:GetEntity("thallP0-position"):GetPosition().x
  g3PosY = Game:GetEntity("thallP0-position"):GetPosition().y
  
  self.p0:AddQuest('D7G_GOAL_2', 'main')
  self.p0:SetQuestPosition('D7G_GOAL_2', g3PosX, g3PosY)
  
  self.p0:AddQuest('D07_FORT', 'side')
  self.p0:SetQuestPosition('D07_FORT', q1PosX, q1PosY)
  
  self.p0:AddQuest('D07_FORWARD_BASE', 'side')
  self.p0:SetQuestPosition('D07_FORWARD_BASE', q2PosX, q2PosX)
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = true
  elseif target == "defeat" then
    self.defeat = true
  elseif target == "artifactGoal" then
		self.p0:WinQuest('D7G_GOAL_1')
    AddNewMarks(self)
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
  self:AddTriggerTarget("artifactGoal")
end
